/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.util;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ButtonArea {
    private Composite buttonArea;

    public ButtonArea(Composite parent, int numButtons) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = numButtons;
        this.buttonArea = new Composite(parent, 0);
        this.buttonArea.setLayout((Layout)layout);
        this.buttonArea.setLayoutData((Object)new GridData(128));
    }

    public void addButton(Button button) {
        try {
            button.paint(this.buttonArea);
        }
        catch (RemoteException e) {
            Logger.error((String)"error while painting button", (Throwable)e);
        }
    }

    public void addButton(String name, Action action) {
        this.addButton(name, action, null);
    }

    public void addButton(String name, Action action, Object context) {
        this.addButton(name, action, context, false);
    }

    public void addButton(String name, Action action, Object context, boolean isDefault) {
        this.addButton(name, action, context, isDefault, null);
    }

    public void addButton(String name, Action action, Object context, boolean isDefault, String icon) {
        Button button = new Button(name, action, context, isDefault, icon);
        try {
            button.paint(this.buttonArea);
        }
        catch (RemoteException e) {
            Logger.error((String)("error while painting button \"" + name + "\""), (Throwable)e);
        }
    }
}

